


/**
 ******************************************************************************
 *
 * @file        MG04_06_Drama.c
 * @brief       MG04_06 drama.
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/03/02
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG04_06_Global.h"
#include "BSP_SPILCD.h"
#include "BSP_ARGB.h"
#include "MG04_06_Drama.h"


/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/


uint8_t const MG04_06_ControlStateTotal[MG04_06_STATE_TOTAL] = {3 , 2, (ARGB_MODE_TOTAL+1), 2, 7, 2};      /*!< Option item in every page.*/
 
uint8_t const MG04_06_ESCDrama[MG04_06_STATE_TOTAL] = { 0xFA, 0, 1, 1, 1, 0};                              /*!< ESC page .*/


/** 
 * @name Front page. 
 */                                                      
///@{
/*Entrance table or act table in trigging Enter function.*/
uint8_t const MG04_06_MainEnterDrama[3] =                                      
{ 
    MG04_06_FUNCTION_NEXTPAGE | MG04_06_STATE_MAIN_ARGBFRONTPAGE, 
    MG04_06_FUNCTION_AUTO, 
    MG04_06_FUNCTION_NEXTPAGE | MG04_06_STATE_MAIN_SETTINGPAGE
};

/*option frame in Front page.*/
uint16_t const MG04_06_MainButtonFrame[3 * 5] =
{
     54,  53, 239, 103, BRED,
      0, 107,  50, 319, BRED,
      0,  53,  50, 103, BRED
};
///@} 

/** 
 * @name ARGB front page.
 */                                                      
///@{
/*Entrance table or act table in trigging Enter function.*/
uint8_t const MG04_06_ARGBMainEnterDrama[2] = 
{
    MG04_06_FUNCTION_NEXTPAGE | MG04_06_STATE_MAIN_ARGBMODEPAGE, 
    MG04_06_FUNCTION_NEXTPAGE | MG04_06_STATE_MAIN_ARGBCOLORPAGE
};

/*option frame*/
uint16_t const MG04_06_ARGBMainButtonFrame[ 2 * 5] = 
{
     15,  95, 113, 206, BRED,
    127,  95, 223, 206, BRED,
};

///@}
 

/** 
 * @name ARGB mode page
 */                                                      
///@{
/*Entrance table or act table in trigging Enter function.*/
uint8_t const MG04_06_ARGBModeEnterDrama[6] = 
{
    MG04_06_FUNCTION_ARGBMODE, 
    MG04_06_FUNCTION_ARGBMODE, 
    MG04_06_FUNCTION_ARGBMODE, 
    MG04_06_FUNCTION_ARGBMODE, 
    MG04_06_FUNCTION_ARGBMODE, 
    MG04_06_FUNCTION_ARGBMODE
};
/*Option frame*/
uint16_t const MG04_06_ARGBModeButtonFrame[ 6 * 5] = 
{
    18,  59, 221,  91, BRED,
    18,  92, 221, 125, BRED,
    18, 127, 221, 159, BRED,
    18, 161, 221, 194, BRED,
    18, 196, 221, 229, BRED,
    18, 231, 221, 265, BRED,
    
};
///@}

/** 
 * @name  ARGB color0 and color1 select page.
 */                                                      
///@{
/*Entrance table or act table in trigging Enter function.*/
uint8_t const MG04_06_ARGB2ColorEnterDrama[2] = 
{
    MG04_06_FUNCTION_NEXTPAGE | MG04_06_STATE_MAIN_ARGBCOLORPAGE,
    MG04_06_FUNCTION_NEXTPAGE | MG04_06_STATE_MAIN_ARGBCOLORPAGE
};
/*option frame*/
uint16_t const MG04_06_ARGB2ColorButtonFrame[ 2 * 5] = 
{
    17,  78,220, 108, BRED,
    17, 110,220, 140, BRED,
};

///@}

/** 
 * @name  Color select page.
 */                                                      
///@{
/*Entrance table or act table in trigging Enter function.*/
uint8_t const MG04_06_ARGBColorEnterDrama[7] = 
{
    MG04_06_FUNCTION_ARGBCOLOR, 
    MG04_06_FUNCTION_ARGBCOLOR, 
    MG04_06_FUNCTION_ARGBCOLOR, 
    MG04_06_FUNCTION_ARGBCOLOR, 
    MG04_06_FUNCTION_ARGBCOLOR, 
    MG04_06_FUNCTION_ARGBCOLOR, 
    MG04_06_FUNCTION_ARGBCOLOR
};
/*option frame*/
uint16_t const MG04_06_ARGBColorButtonFrame[ 7 * 5] = 
{
    17,  81, 81, 134, BRED,
    93,  81,156, 134, BRED,
   167,  81,231, 134, BRED,
    17, 140, 81, 193, BRED,
    93, 140,156, 193, BRED,
   167, 140,231, 193, BRED,
    17, 198, 81, 253, BRED,
};

///@]

/** 
 * @name  Set page
 */                                                      
///@{
/*Entrance table or act table in trigging Enter function.*/
uint8_t const MG04_06_SettingEnterDrama[2] = 
{ 
    MG04_06_FUNCTION_SETTINGLOCK,
    MG04_06_FUNCTION_ESC
};
/*option frame*/
uint16_t const MG04_06_SettingButtonFrame[ 2 * 5] = 
{
    54,  53, 239, 103, BRED,
     0, 107,  50, 319, BRED,
};
///@}


/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/
 
 
 
 
 
 
 
